/*
 * TutorInterface.java
 *
 * Created on April 23, 2003, 12:06 PM
 */

import java.io.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.util.*;
import DORMIN.trace;

/**
 *
 * @author  mike, jonbrown
 */
public class TutorInterface extends pact.DorminWidgets.TutorWindow {

	/** Creates new form TutorInterface */
	public TutorInterface() {
		initComponents();
		super.initTutorWindow();
		//setSize(300, 320);
                loadNextProblem();
	}

	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
    private void initComponents() {//GEN-BEGIN:initComponents
        universalToolProxy1 = new pact.DorminWidgets.UniversalToolProxy();
        jScrollPane1 = new javax.swing.JScrollPane();
        jPanel1 = new javax.swing.JPanel();
        dorminButton2 = new pact.DorminWidgets.DorminButton();
        dorminButton1 = new pact.DorminWidgets.DorminButton();
        jLabel1 = new javax.swing.JLabel();
        jButton1 = new javax.swing.JButton();
        jButton2 = new javax.swing.JButton();
        jLabel2 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        descriptionLabel = new javax.swing.JLabel();
        questionLabel = new javax.swing.JLabel();
        directionLabel = new javax.swing.JLabel();
        dorminTextField1 = new pact.DorminWidgets.DorminTextField();
        jLabel4 = new javax.swing.JLabel();
        jLabel5 = new javax.swing.JLabel();

        universalToolProxy1.setLoggingAuthToken("x");
        universalToolProxy1.setLoggingSessionID("y");
        universalToolProxy1.setLoggingUserID("z");
        universalToolProxy1.setShowAuthorMenu(true);
        universalToolProxy1.setShowDebugInfo(true);
        universalToolProxy1.setShowLoginMenu(true);

        getContentPane().setLayout(new java.awt.GridLayout(1, 0));

        setTitle("Tutor Interface");
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                exitForm(evt);
            }
        });

        jPanel1.setLayout(null);

        dorminButton2.setDorminName("Hint");
        dorminButton2.setText("Help");
        jPanel1.add(dorminButton2);
        dorminButton2.setBounds(450, 440, 90, 40);

        dorminButton1.setDorminName("Done");
        dorminButton1.setText("Done");
        jPanel1.add(dorminButton1);
        dorminButton1.setBounds(40, 440, 90, 40);

        jLabel1.setText("  ");
        jPanel1.add(jLabel1);
        jLabel1.setBounds(380, 290, 20, 20);

        jButton1.setIcon(new javax.swing.ImageIcon("C:\\Documents and Settings\\JonBrown\\Desktop\\717 Project\\Deliverance-Junket\\RecordButton.png"));
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });

        jPanel1.add(jButton1);
        jButton1.setBounds(200, 310, 60, 33);

        jButton2.setIcon(new javax.swing.ImageIcon("C:\\Documents and Settings\\JonBrown\\Desktop\\717 Project\\Deliverance-Junket\\StopButton.png"));
        jButton2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton2ActionPerformed(evt);
            }
        });

        jPanel1.add(jButton2);
        jButton2.setBounds(320, 310, 60, 33);

        jLabel2.setFont(new java.awt.Font("Dialog", 1, 14));
        jLabel2.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel2.setText("Record");
        jPanel1.add(jLabel2);
        jLabel2.setBounds(200, 290, 60, 20);

        jLabel3.setFont(new java.awt.Font("Dialog", 1, 14));
        jLabel3.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel3.setText("Stop");
        jPanel1.add(jLabel3);
        jLabel3.setBounds(320, 290, 60, 20);

        jPanel1.add(descriptionLabel);
        descriptionLabel.setBounds(140, 20, 430, 30);

        jPanel1.add(questionLabel);
        questionLabel.setBounds(170, 140, 390, 110);

        jPanel1.add(directionLabel);
        directionLabel.setBounds(140, 100, 370, 40);

        jPanel1.add(dorminTextField1);
        dorminTextField1.setBounds(140, 370, 310, 40);

        jLabel4.setIcon(new javax.swing.ImageIcon("C:\\Documents and Settings\\jonbrown\\Desktop\\717 Project\\Second Sight\\crook.jpg"));
        jPanel1.add(jLabel4);
        jLabel4.setBounds(0, 0, 90, 97);

        jLabel5.setBackground(new java.awt.Color(102, 102, 102));
        jLabel5.setIcon(new javax.swing.ImageIcon("C:\\Documents and Settings\\jonbrown\\Desktop\\717 Project\\Second Sight\\cop.jpg"));
        jPanel1.add(jLabel5);
        jLabel5.setBounds(40, 220, 80, 130);

        jScrollPane1.setViewportView(jPanel1);

        getContentPane().add(jScrollPane1);

        pack();
    }//GEN-END:initComponents

    private void jButton2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton2ActionPerformed
        // Add your handling code here:
        recognizer.stopRecording();
        recognizer.doRecognize();
        String s[] = recognizer.getNBest();
        
        //get the best match for s
        String spoken = recognizer.getBestMatch(s, currentAnswerChoices);
        
        //String spoken = currentCorrectAnswer;
        //String spoken = recognizer.getBest();
        
        if (spoken.equalsIgnoreCase(currentCorrectAnswer))
        {
            //correct answer
            
            //set text box
            dorminTextField1.setText(spoken);
            FocusEvent fe = new FocusEvent(dorminTextField1, FocusEvent.FOCUS_LOST);
            dorminTextField1.focusLost(fe);
            
            //load the next problem
            loadNextProblem();
        }
        else
        {
            //they spoke one of the incorrect answers or was not understood
            
            //set text box
            dorminTextField1.setText(spoken);
            FocusEvent fe = new FocusEvent(dorminTextField1, FocusEvent.FOCUS_LOST);
            dorminTextField1.focusLost(fe);
        }
    }//GEN-LAST:event_jButton2ActionPerformed

    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
        // Add your handling code here:
        File audioFile = new File ("C:\\sphinx\\sphinx2\\share\\sphinx2\\model\\lm\\current\\current.16k");
        File hypFile = new File ("C:\\sphinx\\sphinx2\\share\\sphinx2\\model\\lm\\current\\current.hyp");
        recognizer = new Recognizer(audioFile, hypFile);
        
        recognizer.startRecording();
    }//GEN-LAST:event_jButton1ActionPerformed

    private void loadNextProblem() {
        String description = "";
        String direction = "";
        String question = "";
        currentAnswerChoices = new Vector();
        
        try {
            BufferedReader br = new BufferedReader(new FileReader("C:\\Documents and Settings\\JonBrown\\Desktop\\717 Project\\Second Sight\\Problem" + questionCount + ".txt"));
            String s = "";
            boolean first = true;
            while ( (s=br.readLine()) != null )
            {
                if (first)
                {
                    first = false;
                    question = "<html>" + s;
                    currentAnswerChoices.add(s);
                }
                else
                {
                    if (s.startsWith("//"))
                    {
                        //we found the answer
                        currentCorrectAnswer = s.substring(2);
                    }
                    else if (s.startsWith("``"))
                    {
                        direction = s.substring(2);
                    }
                    else if (s.startsWith("~~"))
                    {
                        description = s.substring(2);
                    }
                    else
                    {
                        question = question + " <br> " + s;
                        currentAnswerChoices.add(s);
                    }
                }
            }
            
            question = question + "</html>";
            questionLabel.setText(question);

            directionLabel.setText(direction);

            descriptionLabel.setText(description);

            questionCount++;           
        }
        catch (Exception e)
        {
            System.out.println(e.toString());
        }       
    }
    
	/** Exit the Application */
	private void exitForm(
		java.awt.event.WindowEvent evt) { //GEN-FIRST:event_exitForm
		System.exit(0);
	} //GEN-LAST:event_exitForm

	/**
	 * @param args the command line arguments
	 */
	public static void main(String args[]) {
		new TutorInterface().show();
	}

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel descriptionLabel;
    private javax.swing.JLabel directionLabel;
    private pact.DorminWidgets.DorminButton dorminButton1;
    private pact.DorminWidgets.DorminButton dorminButton2;
    private pact.DorminWidgets.DorminTextField dorminTextField1;
    private javax.swing.JButton jButton1;
    private javax.swing.JButton jButton2;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JLabel questionLabel;
    private pact.DorminWidgets.UniversalToolProxy universalToolProxy1;
    // End of variables declaration//GEN-END:variables

    private Recognizer recognizer = null; 
    private int questionCount = 1;
    private String currentCorrectAnswer = "";
    private Vector currentAnswerChoices;
}
